/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class I18nMessageConsumer
implements MessageConsumer {
    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{SystemMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        SystemMessage msg = (SystemMessage)message;
        if (msg.getStatusCode() != 2) {
            return;
        }
        String dir = Application.getConfig().getStoreUntranslatedDir();
        if (dir == null) {
            return;
        }
        File parent = new File(dir);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.store(Application.getI18n(), new File(parent, "system_messages.properties"));
        List<Plugin> plugins = Application.getPluginLoader().getInstalledPlugins();
        for (Plugin p : plugins) {
            String name = p.getManifest().getName();
            this.store(p.getResources().getI18N(), new File(parent, name + "_messages.properties"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(I18N i18n, File file) {
        BufferedOutputStream os = null;
        try {
            Logger.info((String)("storing untranslated strings in " + file));
            os = new BufferedOutputStream(new FileOutputStream(file));
            i18n.storeUntranslated((OutputStream)os);
        }
        catch (Exception e) {
            try {
                Logger.error((String)"unable to store untranslated strings", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
        }
        IOUtil.close((Closeable[])new Closeable[]{os});
    }

    @Override
    public boolean autoRegister() {
        return true;
    }
}

